
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
	[TestFixture]
	public class DAL_RackTest : BaseTest 
	{		
		
		private DataTable _dtRackTest;
		private DataTable _dtRack;
		private DataTable _dtReagent;
		private DataTable _dtDailyQcWorklist;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtRackTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM RackTest WHERE RackTestGuid IN (SELECT RackTestGuid From RackLot WHERE DailyQcWorklistGuid IS NOT NULL AND RackGuid IS NOT NULL AND RecordStatusCode = 'A') AND RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", false);
				if (this._dtRackTest.Rows.Count == 0)
				{
					DataCreator.CreateQCdRack();
					this._dtRackTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM RackTest WHERE RackTestGuid IN (SELECT RackTestGuid From RackLot WHERE DailyQcWorklistGuid IS NOT NULL AND RackGuid IS NOT NULL AND RecordStatusCode = 'A') AND RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", true);
				}
				
				//***Get the Rack data, Racks die easily, so we dont exception on no recs found - then update
				this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE DailyControlGuid IS NOT NULL AND RackGuid IN (SELECT RackGuid FROM RackLot) AND RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "' AND RackGuid IN (SELECT RackGuid FROM DailyQcWorklist)", false);
				if (this._dtRack.Rows.Count == 0)
				{
					DataCreator.CreateQCdRack();
					UnitTestUtil.RunSQL("UPDATE Rack SET RecordStatusCode = 'A' WHERE DailyControlGuid IN (SELECT TOP 1 DailyControlGUid FROM Rack WHERE RackGuid IN (SELECT RackGuid FROM RackLot) AND RackGuid IN (SELECT RackGuid FROM DailyQcWorklist) AND DailyControlGuid IS NOT NULL AND DivisionCode = '" + this.TestDivisionCode + "')");
					this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 Rack.* FROM Rack JOIN RackLot ON Rack.RackGuid = RackLot.RackGuid JOIN DailyQcWorklist ON DailyQcWorklist.RackGuid = Rack.RackGuid WHERE Rack.DailyControlGuid IS NOT NULL AND Rack.RecordStatusCode = 'A' AND Rack.DivisionCode = '" + this.TestDivisionCode + "'", true);
				}

				this._dtDailyQcWorklist = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM DailyQcWorklist WHERE RackGuid = '" + this._dtRack.Rows[0][TABLES.Rack.RackGuid].ToString() + "'", false);
				if (this._dtDailyQcWorklist.Rows.Count == 0)
				{
					DataCreator.CreateQCdRack();
					this._dtDailyQcWorklist = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM DailyQcWorklist WHERE RackGuid = '" + this._dtRack.Rows[0][TABLES.Rack.RackGuid].ToString() + "'", true);
				}

				//*******Reagent
				this._dtReagent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Reagent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", false);
				if (this._dtReagent.Rows.Count == 0)
				{
					DataCreator.CreateQCdRack();
					this._dtReagent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Reagent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", true);
				}


				this.RefreshData = false;
			}

		}


		[Test]
		public void SaveRackTests_Pass()
		{
			this.RefreshData = true;

			Guid reagentGuid = (Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];
			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];

			//Done first to get the RackLotGuid
			DataTable dtRackLots = SprocHelper.GetInsertRackLotSprocTable(reagentGuid, rackGuid);
			Guid rackLotGuid = (Guid)dtRackLots.Rows[0][TABLES.RackLot.RackLotGuid];
			byte[] rackRowVersion = (byte[])this._dtRack.Rows[0][TABLES.Rack.RowVersion];

			DataTable dtRackTestsInsert = SprocHelper.GetInsertRackTestSprocTable(Guid.NewGuid(), rackLotGuid);
			DataTable dtRackTestsUpdate = new DataTable();
			DataTable dtDailyQc = SprocHelper.GetInsertDailyQcWorklistSprocTable(rackGuid);
			DataTable dtExceptions = new DataTable();
			DataTable dtWorkload = new DataTable();

			bool retValue = DAL.RackTest.SaveRackTests(dtRackTestsInsert, dtRackTestsUpdate, dtRackLots, dtDailyQc, dtExceptions, Common.UpdateFunction.UnitTests, dtWorkload, Guid.Empty);
			
			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
        [ExpectedExceptionAttribute(typeof(Common.DataAccessLayerException))]
		public void SaveRackTests_Fail()
		{
			Guid dailyQcWorklistGuid = (Guid)this._dtDailyQcWorklist.Rows[0][TABLES.DailyQcWorklist.DailyQcWorklistGuid];
			Guid reagentGuid = (Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];
			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			
			//Done first to get the RackLotGuid
			DataTable dtRackLots = SprocHelper.GetInsertRackLotSprocTable(reagentGuid, rackGuid);
			Guid rackLotGuid = (Guid)dtRackLots.Rows[0][TABLES.RackLot.RackLotGuid];
			byte[] rackRowVersion = new byte[8];

			DataTable dtRackTestsInsert = SprocHelper.GetInsertRackTestSprocTable(Guid.NewGuid(), rackLotGuid);
			DataTable dtRackTestsUpdate = new DataTable();
			DataTable dtDailyQc = SprocHelper.GetInsertDailyQcWorklistSprocTable(rackGuid);
			dtDailyQc.Rows[0][TABLES.DailyQcWorklist.DailyQcWorklistGuid] = dailyQcWorklistGuid;

			DataTable dtExceptions = new DataTable();
			DataTable dtWorkload = new DataTable();

			DAL.RackTest.SaveRackTests(dtRackTestsInsert, dtRackTestsUpdate, dtRackLots, dtDailyQc, dtExceptions, Common.UpdateFunction.UnitTests, dtWorkload, dailyQcWorklistGuid);
		}

		[Test]
		public void GetRackTestResult_Pass()
		{
			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			Guid reagentGuid = (Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];

			DataTable dtTest = DAL.RackTest.GetRackTestResult(reagentGuid, rackGuid, Guid.Empty);

			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestGuid), TABLES.RackTest.RackTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithName), TABLES.RackLot.TestWithName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithId), TABLES.RackLot.TestWithId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ExpectedMinimumReactions), TABLES.RackLot.ExpectedMinimumReactions);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseText), TABLES.ReactivityPhase.ReactivityPhaseText);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ReactivityPhaseCode), TABLES.RackLot.ReactivityPhaseCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.TestDate), TABLES.RackTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestResult), TABLES.RackTest.RackTestResult);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestResultTypeCode), TABLES.RackTest.RackTestResultTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.ReagentAmount), TABLES.RackTest.ReagentAmount);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.RowVersion), TABLES.RackLot.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.SatisfactoryResultIndicator), TABLES.RackLot.SatisfactoryResultIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.LotVialNumber), TABLES.RackLot.LotVialNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.LastUpdateDate), TABLES.RackTest.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestingMethodCode), TABLES.RackLot.TestingMethodCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ReagentGuid), TABLES.RackLot.ReagentGuid);
		}

		[Test]
		public void GetRackTestResult_Fail()
		{
			Guid rackGuid = Guid.NewGuid();
			Guid reagentGuid = Guid.NewGuid();

			DataTable dtTest = DAL.RackTest.GetRackTestResult(reagentGuid, rackGuid, Guid.Empty);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetPreviousRackTestResult_Pass()
		{
			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			Guid reagentGuid = (Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];
			int testId = 1;
			string testWithName = "A1 Cell";
			string resultTypeCode = string.Empty;

			DataTable dtTest = DAL.RackTest.GetPreviousRackTestResult(reagentGuid, rackGuid, testId, testWithName, resultTypeCode, BOL.VBECSDateTime.GetDivisionCurrentDateTime());

			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestResult), TABLES.RackTest.RackTestResult);
		}

		[Test]
		public void GetPreviousRackTestResult_Fail()
		{
			Guid rackGuid = Guid.NewGuid();
			Guid reagentGuid = Guid.NewGuid();
			int testId = 1;
			string testWithName = "A1 Cell";
			string resultTypeCode = string.Empty;

			DataTable dtTest = DAL.RackTest.GetPreviousRackTestResult(reagentGuid, rackGuid, testId, testWithName, resultTypeCode, DateTime.Now.AddYears(10));

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void InactivateRackTestResults_Pass()
		{
			this.RefreshData = true;
			
			// Three tables: RackTest, RackLot, DailyQcWorklist
			DataSet rackData = DAL.RackTest.GetRackInfoByDailyQcWorklistGuid( (Guid)this._dtDailyQcWorklist.Rows[0][TABLES.DailyQcWorklist.DailyQcWorklistGuid] );
			//
			DataTable dtRackTest = Common.Utility.AppendLastUpdateInformation( rackData.Tables[0], Common.UpdateFunction.UnitTests );
			//
			DataTable dtRackLot = Common.Utility.AppendLastUpdateInformation( rackData.Tables[1], Common.UpdateFunction.UnitTests );
			//
			DataTable dtDailyQcWorklist = Common.Utility.AppendLastUpdateInformation( rackData.Tables[2], Common.UpdateFunction.UnitTests );
			//
			DataTable dtException1 = new DataTable();
			DataTable dtException2 = new DataTable();
		
			bool retValue = DAL.RackTest.InactivateRackTestResults(dtRackLot, dtRackTest, dtDailyQcWorklist, dtException1, dtException2);

			if (retValue)
			{
				int uCheck = UnitTestUtil.RunSQL("UPDATE RackTest SET RecordStatusCode = 'A' WHERE RackLotGuid IN (SELECT RackLotGuid FROM RackLot WHERE RackGuid = '" + this._dtRack.Rows[0][TABLES.Rack.RackGuid].ToString() + "')");
			}

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void InactivateRackTestResults_Fail()
		{
			this.RefreshData = true;
			//
			Guid qcGuid = DataCreator.GetRecordGuid("SELECT TOP 1 DailyQcWorklistGuid FROM RackLot WHERE RackLotGuid IN (SELECT RackLotGuid FROM RackTest) AND DivisionCode = '" + this.TestDivisionCode + "' AND DailyQcWorklistGuid IS NOT NULL");
			if (qcGuid == Guid.Empty) Assert.IsTrue(false, "No data available for test");

			// Three tables: RackTest, RackLot, DailyQcWorklist
			DataSet rackData = DAL.RackTest.GetRackInfoByDailyQcWorklistGuid(qcGuid);
			//
			DataTable dtRackTest = Common.Utility.AppendLastUpdateInformation( rackData.Tables[0], Common.UpdateFunction.UnitTests );
			//
			DataTable dtRackLot = Common.Utility.AppendLastUpdateInformation( rackData.Tables[1], Common.UpdateFunction.UnitTests );
			//
			DataTable dtDailyQcWorklist = Common.Utility.AppendLastUpdateInformation( rackData.Tables[2], Common.UpdateFunction.UnitTests );
			//
			DataTable dtException1 = new DataTable();
			DataTable dtException2 = new DataTable();
		
			dtRackLot.Rows[0][TABLES.RackLot.RowVersion] = new byte[8];
			dtRackTest.Rows[0][TABLES.RackTest.RowVersion] = new byte[8];
			dtDailyQcWorklist.Rows[0][TABLES.DailyQcWorklist.RowVersion] = new byte[8];

			bool retValue = DAL.RackTest.InactivateRackTestResults(dtRackLot, dtRackTest, dtDailyQcWorklist, dtException1, dtException2);
		}

		
		[Test]
		public void GetRackInfoByDailyQcWorklistGuid_Pass()
		{
			Guid worklistGuid = (Guid)this._dtDailyQcWorklist.Rows[0][TABLES.DailyQcWorklist.DailyQcWorklistGuid];

			DataSet dsTest = DAL.RackTest.GetRackInfoByDailyQcWorklistGuid(worklistGuid);

			Assert.AreEqual(3, dsTest.Tables.Count, "Tables.Count");

			Assert.AreEqual(2, dsTest.Tables[0].Columns.Count, "Table[0].Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.RackTest.RackTestGuid), "[0]- " + TABLES.RackTest.RackTestGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.RackTest.RowVersion), "[0]- " + TABLES.RackTest.RowVersion);

			Assert.AreEqual(2, dsTest.Tables[1].Columns.Count, "Table[1].Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.RackLot.RackLotGuid), "[1]- " + TABLES.RackLot.RackLotGuid);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.RackLot.RowVersion), "[1]- " + TABLES.RackLot.RowVersion);

			Assert.AreEqual(2, dsTest.Tables[2].Columns.Count, "Table[2].Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.DailyQcWorklist.DailyQcWorklistGuid), "[2]- " + TABLES.DailyQcWorklist.DailyQcWorklistGuid);
			Assert.AreEqual(true, dsTest.Tables[2].Columns.Contains(TABLES.DailyQcWorklist.RowVersion), "[2]- " + TABLES.DailyQcWorklist.RowVersion);
		}

		
		[Test]
		public void GetRackInfoByDailyQcWorklistGuid_Fail()
		{
			DataSet dsTest = DAL.RackTest.GetRackInfoByDailyQcWorklistGuid(Guid.NewGuid());

			Assert.AreEqual(3, dsTest.Tables.Count, "Tables.Count");

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Table[0].Rows.Count");
			Assert.AreEqual(0, dsTest.Tables[1].Rows.Count, "Table[1].Rows.Count");
			Assert.AreEqual(0, dsTest.Tables[2].Rows.Count, "Table[2].Rows.Count");
		}

		[Test]
		public void GetReagentTestResult_String_Guid_Pass()
		{
			Guid reagentGuid = (Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];

			DataTable dtTest = DAL.RackTest.GetReagentTestResult(this.TestDivisionCode, reagentGuid);

			Assert.AreEqual(12, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestGuid), TABLES.RackTest.RackTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithName), TABLES.RackLot.TestWithName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithId), TABLES.RackLot.TestWithId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ExpectedMinimumReactions), TABLES.RackLot.ExpectedMinimumReactions);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseText), TABLES.ReactivityPhase.ReactivityPhaseText);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ReactivityPhaseCode), TABLES.RackLot.ReactivityPhaseCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.TestDate), TABLES.RackTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestResult), TABLES.RackTest.RackTestResult);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestResultTypeCode), TABLES.RackTest.RackTestResultTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.ReagentAmount), TABLES.RackTest.ReagentAmount);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.SatisfactoryResultIndicator), TABLES.RackLot.SatisfactoryResultIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.LastUpdateDate), TABLES.RackTest.LastUpdateDate);
		}

		[Test]
		public void GetReagentTestResult_String_Guid_Fail()
		{
			DataTable dtTest = DAL.RackTest.GetReagentTestResult(string.Empty, Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetReagentTestResult_String_Guid_Date_Pass()
		{
			Guid reagentGuid = (Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];
			DateTime testDate = (DateTime)this._dtRackTest.Rows[0][TABLES.RackTest.TestDate];

			DataTable dtTest = DAL.RackTest.GetReagentTestResult(this.TestDivisionCode, reagentGuid, testDate);

			Assert.AreEqual(12, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestGuid), TABLES.RackTest.RackTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithName), TABLES.RackLot.TestWithName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithId), TABLES.RackLot.TestWithId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ExpectedMinimumReactions), TABLES.RackLot.ExpectedMinimumReactions);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseText), TABLES.ReactivityPhase.ReactivityPhaseText);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ReactivityPhaseCode), TABLES.RackLot.ReactivityPhaseCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.TestDate), TABLES.RackTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestResult), TABLES.RackTest.RackTestResult);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestResultTypeCode), TABLES.RackTest.RackTestResultTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.ReagentAmount), TABLES.RackTest.ReagentAmount);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.SatisfactoryResultIndicator), TABLES.RackLot.SatisfactoryResultIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.LastUpdateDate), TABLES.RackTest.LastUpdateDate);
		}

		[Test]
		public void GetReagentTestResult_String_Guid_Date_Fail()
		{
			DataTable dtTest = DAL.RackTest.GetReagentTestResult(string.Empty, Guid.NewGuid(), DateTime.Now);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetReagentTestResult_String_Guid_Date_Char_Pass()
		{
			Guid reagentGuid = (Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];
			DateTime testDate = (DateTime)this._dtRackTest.Rows[0][TABLES.RackTest.TestDate];
			char phaseCode = 'A';

			DataTable dtTest = DAL.RackTest.GetReagentTestResult(this.TestDivisionCode, reagentGuid, testDate, phaseCode);

			Assert.AreEqual(12, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestGuid), TABLES.RackTest.RackTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithName), TABLES.RackLot.TestWithName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithId), TABLES.RackLot.TestWithId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ExpectedMinimumReactions), TABLES.RackLot.ExpectedMinimumReactions);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseText), TABLES.ReactivityPhase.ReactivityPhaseText);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ReactivityPhaseCode), TABLES.RackLot.ReactivityPhaseCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.TestDate), TABLES.RackTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestResult), TABLES.RackTest.RackTestResult);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestResultTypeCode), TABLES.RackTest.RackTestResultTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.ReagentAmount), TABLES.RackTest.ReagentAmount);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.SatisfactoryResultIndicator), TABLES.RackLot.SatisfactoryResultIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.LastUpdateDate), TABLES.RackTest.LastUpdateDate);
		}

		[Test]
		public void GetReagentTestResult_String_Guid_Date_Char_Fail()
		{
			DataTable dtTest = DAL.RackTest.GetReagentTestResult(this.TestDivisionCode, Guid.NewGuid(), DateTime.Now, 'A');

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


	}
}
#endif
